//
//  PDFHttpStream.m
//  PDFViewer
//
//  Created by strong on 14-3-23.
//
//

#import "PDFHttpStream.h"

@implementation PDFHttpStream

-(id)init
{
    if( self = [super init] )
    {
        m_file = NULL;
        m_total = 0;
        m_pos = 0;
        m_block_cnt = 0;
        m_block_flags = NULL;
        m_url = NULL;
    }
    return self;
}

-(void)dealloc
{
    [self close];
}

-(BOOL)open :(NSString *)url :(NSString *)cache_file;
{
    m_url = [NSURL URLWithString:url];
    m_cache_path = cache_file;
    [self init_length];
    return m_file && m_total > 0;
}

// Modified by lseverini
-(void)init_length
{
    // Send a synchronous request
    NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:m_url
                                                              cachePolicy:NSURLRequestUseProtocolCachePolicy
                                                          timeoutInterval:30.0];
    urlRequest.HTTPMethod = @"HEAD";
    [urlRequest setValue:@"Keep-Alive" forHTTPHeaderField:@"Close"];

    static NSOperationQueue *queue = nil;
    if (queue == nil)
    {
        queue = [[NSOperationQueue alloc] init];
    }

    // Init semaphore
    dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);

    __block NSHTTPURLResponse *httpResponse = nil;
    [NSURLConnection sendAsynchronousRequest:urlRequest
                                       queue:queue
                           completionHandler:^(NSURLResponse *response, NSData *data, NSError *error)
    {
        if (error != nil)
        {
            printf("Error: %s\n", [[error description] UTF8String]);
        }
        else
        {
            httpResponse = (NSHTTPURLResponse*)response;
        }

        // Release semaphore
        dispatch_semaphore_signal(semaphore);
    }];

    // Wait until semaphore is released
    dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);

    if (httpResponse != nil)
    {
        long len = [[[httpResponse allHeaderFields] objectForKey:@"Content-Length"] intValue];
        m_total = (int)len;

        printf("httpResponse length: %ld\n", len);

        [NSURLConnection cancelPreviousPerformRequestsWithTarget:urlRequest];
        if( len > 0 )
        {
            m_file = fopen([m_cache_path UTF8String], "wb+"); // read-write cached file.
            unsigned char tmp[4096];
            memset( tmp, 0, 4096 );
            int cur = 0;
            while( cur < m_total - 4095 )
            {
                fwrite( tmp, 1, 4096, m_file );
                cur += 4096;
            }
            fwrite( tmp, 1, m_total - cur, m_file );
            m_block_cnt = (m_total + BLOCK_SIZE - 1)/BLOCK_SIZE;
            m_block_flags = (unsigned char *)malloc(m_block_cnt * sizeof(unsigned char));
            memset( m_block_flags, 0, m_block_cnt * sizeof(unsigned char) ); // init all flags.

            printf("%s\n", [[NSString stringWithFormat:@"END write file at path: %@", m_cache_path] UTF8String]);
        }
        else
        {
            printf("NO DATA.\n");
        }
    }
}

-(bool)writeable
{
    return false;
}

-(void)close
{
    if( m_file )
    {
        fclose(m_file);
        m_file = NULL;
        unlink( [m_cache_path UTF8String] );
    }
    if( m_block_flags )
    {
        free( m_block_flags );
        m_block_flags = NULL;
    }
    m_total = 0;
    m_pos = 0;
    m_block_cnt = 0;
    m_url = NULL;
}

// Modified by lseverini
-(bool)download_blocks :(int) start :(int)end
{
    printf("%s\n", [[NSString stringWithFormat:@"    Download blocks: %d to %d", start, end] UTF8String]);

    bool ret = true;

    while( start < end )
    {
        while( start < end && m_block_flags[start] ) start++;
        int prev = start;
        while( start < end && !m_block_flags[start] ) start++;
        if( start > prev )
        {
            int len = 0;
            int off = prev * BLOCK_SIZE;
            len = m_total - off;
            if( len > (start - prev) * BLOCK_SIZE )
            {
                len = (start - prev) * BLOCK_SIZE;
            }
            
            NSMutableURLRequest* urlRequest = [NSMutableURLRequest requestWithURL:m_url
                                                                      cachePolicy:NSURLRequestUseProtocolCachePolicy
                                                                  timeoutInterval:60 + 30 * (start - prev - 1)];
            [urlRequest setHTTPMethod:@"GET"];
            NSString *hval = [NSString stringWithFormat:@"bytes=%i-%i", off, off + len];
            [urlRequest setValue:hval forHTTPHeaderField:@"Range"];

            printf("%s\n", [[NSString stringWithFormat:@"        Starting request to %@ with byte range: %d-%d", m_url, off, off + len] UTF8String]);

            // Init semaphore
            dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);

            __block NSData *responseData = nil;
            NSURLSession *session = [NSURLSession sharedSession];
            NSURLSessionDataTask *task = [session dataTaskWithRequest:urlRequest
                                                    completionHandler:^(NSData *data, NSURLResponse *response, NSError *error)
            {
                if (error != nil)
                {
                    printf("Error: %s\n", [[error description] UTF8String]);
                }
                else
                {
                    responseData = data;
                }

                // Release semaphore
                dispatch_semaphore_signal(semaphore);
            }];

            [task resume];

            // Wait until semaphore is released
            dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);

            if(responseData != NULL)
            {
                printf("%s\n", [[NSString stringWithFormat:@"        OK."] UTF8String]);

                memset( m_block_flags + prev, 1, start - prev );
                fseek( m_file, off, SEEK_SET );
                fwrite( [responseData bytes], 1, len, m_file );
            }
            else
            {
                printf("%s\n", [[NSString stringWithFormat:@"        Failure."] UTF8String]);

                ret = false;
            }
        }
    }

    return ret;
}

-(int)read :(void *)data :(int) len
{
    printf("%s\n", [[NSString stringWithFormat:@"Read data: %d bytes", len] UTF8String]);

    if( !m_file )
    {
        return 0;
    }

    int bstart = m_pos / BLOCK_SIZE;
    int bend = (m_pos + len + BLOCK_SIZE - 1)/BLOCK_SIZE;

    if( bend > m_block_cnt )
    {
        bend = m_block_cnt;
    }

    int times = 3;
    while( times > 0 && ![self download_blocks:bstart:bend])
    {
        times--;
    }
    if( times == 0 )
    {
        return 0;
    }

    fseek( m_file, m_pos, SEEK_SET );
    int ret = (int)fread( data, 1, len, m_file );
    m_pos += ret;

    return ret;
}

-(int)write :(const void *)data :(int)len
{
    return 0;
}

-(unsigned long long)position
{
    if( !m_file ) return 0;
    return m_pos;
}

-(unsigned long long)length
{
    if( !m_file ) return 0;
    return m_total;
}

-(bool)seek:(unsigned long long)pos
{
    if( !m_file ) return false;
    if( pos < 0.00000000001 ) pos = 0;
    if( pos > m_total ) pos = m_total;
    if(pos == m_pos) return true;
    m_pos = (int)pos;
    return true;
}

@end
